-- Full credit goes to EmeraldLockdown for this theme system found in Tag

---@param r integer|number
---@param g integer|number
---@param b integer|number
local function color(r, g, b, a)
    if not a then a = 255 end
    return { r = r, g = g, b = b, a = a }
end

local templateTheme = {
    name = "Template",
    background = color(20, 20, 22),
    backgroundOutline = color(45, 45, 47),
    backgroundGlow = color(0, 0, 0, 0),
    rect = color(32, 32, 32, 128),
    rectOutline = color(50, 50, 50),
    hoverRect = color(40, 40, 40),
    hoverRectOutline = color(60, 60, 60),
    text = color(220, 220, 220),
    selectedText = color(240, 240, 240),
    disabledText = color(150, 150, 150),
    leaderboard = color(32, 32, 32, 128),
    leaderboardOutline = color(50, 50, 50),
    minimap = color(32, 32, 32, 100),
    minimapOutline = color(50, 50, 50),
    welcomeMessage = color(20, 20, 22, 155),
    welcomeMessageOutline = color(45, 45, 47, 255),
    pauseBackground = color(20, 20, 22, 128),
    builtin = false,
}

floodThemes = {
    {
        name = "Aqua Blue",
        background = color(20, 20, 50),
        backgroundOutline = color(45, 45, 90),
        rect = color(32, 32, 79, 128),
        rectOutline = color(45, 45, 90),
        hoverRect = color(40, 40, 100),
        hoverRectOutline = color(45, 45, 90),
        text = color(220, 220, 220),
        selectedText = color(240, 240, 240),
        disabledText = color(150, 150, 150),
        leaderboard = color(32, 32, 79, 128),
        leaderboardOutline = color(45, 45, 90),
        minimap = color(32, 32, 79, 100),
        minimapOutline = color(45, 45, 90),
        welcomeMessage = color(20, 20, 50, 155),
        welcomeMessageOutline = color(45, 45, 90, 255),
        pauseBackground = color(20, 20, 80, 128),
        builtin = true,
    },
    {
        name = "Sea Green",
        background = color(0, 50, 20),
        backgroundOutline = color(45, 90, 45),
        rect = color(32, 79, 32, 128),
        rectOutline = color(50, 90, 50),
        hoverRect = color(40, 100, 40),
        hoverRectOutline = color(45, 90, 45),
        text = color(220, 220, 220),
        selectedText = color(240, 240, 240),
        disabledText = color(150, 150, 150),
        leaderboard = color(32, 79, 32, 128),
        leaderboardOutline = color(50, 90, 50),
        minimap = color(32, 79, 32, 100),
        minimapOutline = color(50, 90, 50),
        welcomeMessage = color(0, 50, 20, 155),
        welcomeMessageOutline = color(45, 90, 45, 255),
        pauseBackground = color(0, 50, 20, 128),
        builtin = true,
    },
    {
        name = "Basic Dark",
        background = color(0, 0, 0),
        backgroundOutline = color(20, 20, 20),
        rect = color(0, 0, 0, 128),
        rectOutline = color(40, 40, 40),
        hoverRect = color(10, 10, 10),
        hoverRectOutline = color(45, 45, 90),
        text = color(220, 220, 220),
        selectedText = color(240, 240, 240),
        disabledText = color(150, 150, 150),
        leaderboard = color(0, 0, 0, 128),
        leaderboardOutline = color(40, 40, 40),
        minimap = color(0, 0, 0, 100),
        minimapOutline = color(40, 40, 40),
        welcomeMessage = color(0, 0, 0, 155),
        welcomeMessageOutline = color(20, 20, 20, 255),
        pauseBackground = color(0, 0, 0, 128),
        builtin = true,
    },
    {
        name = "Basic Light",
        background = color(225, 225, 225),
        backgroundOutline = color(185, 185, 185),
        rect = color(185, 185, 185, 128),
        rectOutline = color(175, 175, 175),
        hoverRect = color(225, 225, 225),
        hoverRectOutline = color(175, 175, 255),
        text = color(0, 0, 0),
        selectedText = color(240, 240, 240),
        disabledText = color(150, 150, 150),
        leaderboard = color(185, 185, 185, 128),
        leaderboardOutline = color(175, 175, 175),
        minimap = color(185, 185, 185, 100),
        minimapOutline = color(175, 175, 175),
        welcomeMessage = color(225, 225, 225, 155),
        welcomeMessageOutline = color(185, 185, 185, 255),
        pauseBackground = color(225, 225, 225, 128),
        builtin = true,
    }
}

local latestThemeVersion = "v1.0"

local themeFormats = {
    ["v1.0"] = {
        "background",
        "backgroundOutline",
        "rect",
        "rectOutline",
        "hoverRect",
        "hoverRectOutline",
        "text",
        "selectedText",
        "disabledText",
        "leaderboard",
        "leaderboardOutline",
        "minimap",
        "minimapOutline",
        "welcomeMessage",
        "welcomeMessageOutline",
        "pauseBackground"
    },
}

function save_theme(themeIndex)
    local function rgba_to_str(rgba)
        return rgba.r .. "_" .. rgba.g .. "_" .. rgba.b .. "_" .. rgba.a .. "_"
    end

    local themeFormat = themeFormats[latestThemeVersion]
    local theme = floodThemes[themeIndex]
    local saveString = latestThemeVersion .. "_"
    for k, v in ipairs(themeFormat) do
        saveString = saveString .. rgba_to_str(theme[v])
    end
    saveString = saveString .. theme.name:gsub(" ", "-") .. "_"

    -- get amount of builtin themes
    local builtinThemes = 0
    for _, v in ipairs(floodThemes) do
        if v.builtin then
            builtinThemes = builtinThemes + 1
        end
    end

    mod_storage_save("theme_" .. themeIndex - builtinThemes, saveString)
end

function load_theme(themeIndex)
    if VERSION_NUMBER < 37 or (VERSION_NUMBER == 37 and MINOR_VERSION_NUMBER < 3) then
        return nil
    end

    local function str_to_rgba(str)
        local r, g, b, a = str:match("(%d+)_(%d+)_(%d+)_(%d+)")
        if not tonumber(a) then a = "255" end
        return color(tonumber(r), tonumber(g), tonumber(b), tonumber(a))
    end

    -- load theme string
    local savedTheme = mod_storage_load("theme_" .. themeIndex)
    -- if the saved theme does not load, stop loading theme
    if savedTheme == nil or savedTheme == "" then return end
    -- get theme format for that version
    local themeFormat = themeFormats["v1.0"]
    local themeVersion = ""
    if savedTheme:sub(1, 1) == "v" then
        for i = 1, #savedTheme do
            if savedTheme:sub(i, i) ~= "_" then themeVersion = themeVersion .. savedTheme:sub(i, i)
            else savedTheme = savedTheme:sub(i + 1, #savedTheme) break end
        end

        if themeFormats[themeVersion] then themeFormat = themeFormats[themeVersion] else themeVersion = "v1.0" end
    end
    log_to_console(themeVersion)

    -- get number of builtin themes
    local builtinThemes = 0
    for _, v in ipairs(floodThemes) do
        if v.builtin then
            builtinThemes = builtinThemes + 1
        end
    end
    -- create a new theme entry
    floodThemes[themeIndex + builtinThemes] = table.copy(templateTheme)
    -- get theme table
    local theme = floodThemes[themeIndex + builtinThemes]

    -- get each and every color
    local colorStrings = {}

    local function get_four_from_1(i)
        return colorStrings[i] .. "_" .. colorStrings[i + 1] .. "_" .. colorStrings[i + 2] .. "_" .. colorStrings[i + 3]
    end

    for c in savedTheme:gmatch("([^%_]+)%_") do
        table.insert(colorStrings, c)
    end

    -- the name is the same across all versions, no compatibility issues there
    theme.name = table.remove(colorStrings):gsub("-", " ")
    -- also set builtin to false
    theme.builtin = false

    local strStartEntry = 1
    for _, v in ipairs(themeFormat) do
        theme[v] = str_to_rgba(get_four_from_1(strStartEntry))
        strStartEntry = strStartEntry + 4
    end
end

function validate_theme()
    if floodThemes[selectedTheme] == nil then
        if mod_storage_load_number("theme") ~= nil then selectedTheme = mod_storage_load_number("theme") end
        if floodThemes[selectedTheme] == nil then
            selectedTheme = 1
        end
    end
end